<?php
function my_theme_enqueue_styles() { 
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
}
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );

//Page Slug Body Class
function add_slug_body_class( $classes ) {
global $post;
if ( isset( $post ) ) {
$classes[] = $post->post_type . '-' . $post->post_name;
}
return $classes;
}
add_filter( 'body_class', 'add_slug_body_class' );

// Allow other font formats
add_filter('upload_mimes', 'custom_mime_types', 999999);

function custom_mime_types($mimes) {
  $mimes['otf'] = 'application/x-font-opentype';
  $mimes['woff'] = 'application/font-woff';
  $mimes['woff2'] = 'application/font-woff2';
  return $mimes;
}

/* Custom Font Types Support */
add_filter('et_pb_supported_font_formats', 'custom_font_formats', 1);

function custom_font_formats() { 
return array('otf', 'woff', 'woff2');
}
